/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.sfp;

import com.ibm.hsc.auiml.databeans.sfp.SFPServiceableEventDetailsBean;
import com.ibm.hsc.auiml.databeans.sfp.SFPServiceableEventLauncherUtil;
import com.ibm.hsc.auiml.databeans.sfp.SFPServiceableEventOverviewBean;
import com.ibm.hsc.auiml.databeans.sfp.SFPUtil;
import com.ibm.hsc.auiml.databeans.sfp.data.ServiceableEvent;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hwmca.common.log.ClassLogInfo;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.TaskNotifyCompleteEvent;
import com.ibm.ui.framework.TaskNotifyCompleteListener;
import com.ibm.ui.framework.UserTaskManager;

public class SFPServiceableEventOverviewButtonHandler
implements TaskActionListener,
TaskNotifyCompleteListener {
    private static final ClassLogInfo _logInfo = new ClassLogInfo(-88, 108, "SFPSEOBHdlr");
    private static final short ERRID_0030 = 48;
    private static final short ERRID_0031 = 49;
    private static final String TRACE_MASKD = "JSEVENTD";
    private static final String TRACE_MASKF = "JSEVENTF";
    private static final String TRACE_MASKT = "JSEVENTT";
    static final String DETAILS_CMD = "Details";
    static final String MENU_DETAILS_CMD = "Menu1.MenuDetails";
    static final String CRITERIA_CMD = "Criteria";
    static final String TABLE_COMPONENT = "EventTable";
    static final String SORT_COMPONENT = "SortColumn";

    public SFPServiceableEventOverviewButtonHandler() {
        Trace.trace(TRACE_MASKT, "->SFPServiceableEventOverviewButtonHandler.c-tor()");
        Trace.trace(TRACE_MASKT, "<-SFPServiceableEventOverviewButtonHandler.c-tor()");
    }

    public void actionPerformed(TaskActionEvent taskActionEvent) {
        Trace.trace(TRACE_MASKT, "->SFPServiceableEventOverviewButtonHandler.actionPerformed()");
        SFPServiceableEventOverviewBean sFPServiceableEventOverviewBean = null;
        UserTaskManager userTaskManager = null;
        try {
            String string = taskActionEvent.getElementName();
            userTaskManager = (UserTaskManager)taskActionEvent.getSource();
            sFPServiceableEventOverviewBean = (SFPServiceableEventOverviewBean)userTaskManager.getDataObjects()[0];
            if (string.equals(DETAILS_CMD) || string.equals(MENU_DETAILS_CMD)) {
                this.launchDetails(userTaskManager, sFPServiceableEventOverviewBean);
            } else if (string.equals(CRITERIA_CMD)) {
                SFPServiceableEventLauncherUtil.launchSearchCriteria(userTaskManager, sFPServiceableEventOverviewBean.getCriteria());
            }
        }
        catch (Throwable throwable) {
            new AusMicrocodeLog(_logInfo, 48, throwable).writeEntry(sFPServiceableEventOverviewBean != null ? sFPServiceableEventOverviewBean.getTargetClass() : null);
            try {
                SFPUtil.showSFPErrorWindowMessageModal("0002", HSCResourceBundleUtil.getMessage("SFPResourceBundleMessages", "0002", "Unable to process request."), HSCResourceBundleUtil.getMessage("SFPResourceBundle", "SFP_MESSAGE_ERROR_TITLE", "Service Focal Point Error"), userTaskManager);
            }
            catch (Exception exception) {
                SFPUtil.showSFPErrorWindowMessageModal("0000", "Unable to process request.", HSCResourceBundleUtil.getMessage("SFPResourceBundle", "SFP_MESSAGE_ERROR_TITLE", "Service Focal Point Error"), userTaskManager);
            }
        }
        Trace.trace(TRACE_MASKT, "<-SFPServiceableEventOverviewButtonHandler.actionPerformed()");
    }

    public void taskCompleted(TaskNotifyCompleteEvent taskNotifyCompleteEvent) {
        Trace.trace(TRACE_MASKT, "-> SFPServiceableEventOverviewButtonHandler.taskCompleted()");
        UserTaskManager userTaskManager = (UserTaskManager)taskNotifyCompleteEvent.getSource();
        String string = taskNotifyCompleteEvent.getElementName();
        String string2 = taskNotifyCompleteEvent.getValue();
        Trace.trace(TRACE_MASKD, "SFPServiceableEventOverviewButtonHandler.taskCompleted() called with elementName " + string + " and value " + string2);
        SFPServiceableEventOverviewBean sFPServiceableEventOverviewBean = (SFPServiceableEventOverviewBean)userTaskManager.getDataObjects()[0];
        if (string.equals(SORT_COMPONENT)) {
            Trace.trace(TRACE_MASKD, "SFPServiceableEventOverviewButtonHandler.taskCompleted() sorting table");
            userTaskManager.storeAllElements();
            sFPServiceableEventOverviewBean.sort();
        }
        Trace.trace(TRACE_MASKT, "<- SFPServiceableEventOverviewButtonHandler.taskCompleted()");
    }

    private void launchDetails(UserTaskManager userTaskManager, SFPServiceableEventOverviewBean sFPServiceableEventOverviewBean) {
        Trace.trace(TRACE_MASKT, "->SFPServiceableEventOverviewButtonHandler.launchDetails()");
        ServiceableEvent serviceableEvent = sFPServiceableEventOverviewBean.getSelectedEvent();
        if (serviceableEvent != null) {
            serviceableEvent.refreshFromServer(sFPServiceableEventOverviewBean.getTargetClass());
            SFPServiceableEventDetailsBean sFPServiceableEventDetailsBean = new SFPServiceableEventDetailsBean(serviceableEvent, sFPServiceableEventOverviewBean.getTargetClass());
            SFPServiceableEventLauncherUtil.launchServiceableEventDetails(userTaskManager, sFPServiceableEventDetailsBean);
            sFPServiceableEventOverviewBean.populatePanel();
        } else {
            Trace.trace(TRACE_MASKD, "SFPServiceableEventOverviewButtonHandler.launchDetails() no event selected");
        }
        Trace.trace(TRACE_MASKT, "->SFPServiceableEventOverviewButtonHandler.launchDetails()");
    }
}

